function err = fit_spd(pdf_x,pdf_vals,N,params)
    arl = params(1);
    brl = params(2);
    crl = params(3);
    ars = params(4);
    brs = params(5);
    crs = params(6);
    asr = params(7);
    bsr = params(8);
    csr = params(9);
    coeff = params(10);

    % define normalised parameters from the theory
    gam = crs/asr;
    ea = (2*arl+ars)/asr;
    eb = (bsr-brs)/asr;
    xi = brl/asr;
    
    % defines the SPD from the approximated theory
    spd = @(z) coeff.*(gam+2-sqrt(4+4.*gam+(gam.*z).^2)).^((2+gam).*ea.*N/(2.*gam+4*xi) - 1) .* exp(eb*N*gam.*z.^2/(4*gam+8*xi) + ea*N.*sqrt(4+4*gam+(gam.*z).^2)/(2*gam+4*xi));
   
    zz = pdf_x/N;

    % guarantees that the parameter set is the regime the appxorimation is
    % good (curved manifold approximation)
    err = sum((pdf_vals-spd(zz)).^2) + (ea^2 + eb^2 + (crl)^2 + (csr)^2);
end